DROP TRIGGER IF EXISTS ab2__a_u__resource_requirement__update ON public.ab2; -- alter Name

CREATE OR REPLACE FUNCTION ab2__a_u__resource_requirement_options__ksvba__update()
  RETURNS TRIGGER AS $$

  DECLARE

      _prefix varchar := 'TRIGGER ab2__a_u__resource_requirement__update -';
      _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

  BEGIN

      -- Debug
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% a2_id:%;', _prefix, new.a2_id;
      END IF;

      -- AG-Ressource anlegen, falls diese noch fehlt.
      INSERT INTO scheduling.resource( context, context_id )
           VALUES                    ( 'ab2'  , new.a2_id  )
           ON CONFLICT ( context, context_id ) DO NOTHING;
      -- ABK-Ressource anlegen, falls diese nocht fehlt.
      INSERT INTO scheduling.resource( context, context_id   )
           VALUES                    ( 'abk'  , new.a2_ab_ix )
           ON CONFLICT ( context, context_id ) DO NOTHING;
      -- Das mit dem AG verknüpftes Ressourcen-Netzwerk aufbauen.
      PERFORM scheduling.ab2__resource_requirements_options__ksvba__from__ab2__create( new, _loglevel => _loglevel );

      RETURN new;

  END $$ LANGUAGE plpgsql;
 --
 DROP TRIGGER IF EXISTS ab2__a_u__resource_requirement_options__ksvba__update ON public.ab2;
 CREATE TRIGGER ab2__a_u__resource_requirement_options__ksvba__update
  AFTER UPDATE OF a2_ab_ix, a2_ks, a2_ksap, a2_o2_id, a2_ende
  ON ab2
  FOR EACH ROW
  WHEN (NOT new.a2_ende)
  EXECUTE PROCEDURE ab2__a_u__resource_requirement_options__ksvba__update();
